<?php /*Template Name: profile */ ?>
<?php get_header(); ?>
<?php
global $wpdb, $current_user;
$userId = get_current_user_id();
if (!is_user_logged_in()) :
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
endif;
?>

<section class="content">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title(); ?>  ( <?php echo $current_user->nickname; ?>)
        </h1>


     
        <div class="profile-head mb-4">
            <div class="row align-items-center justify-content-between">
                <div class="col-md-auto">
                    <div class="user-avatar">
                        <img class="img-fluid" src="<?php echo $img; ?>"/>
                    </div>
                </div>
                <div class="col-md-auto">
                    <div class="profile-edit-url">
                        <a class="main-button"
                           href="<?php echo get_page_link(90) ?>">
                           <span> <?php _e('تعديل البيانات', 'm7md') ?></span>
	                        <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
		                        '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped">
                <tbody>
                <tr>
                    <td><?php _e('إسم المستخدم', 'm7md') ?></td>
                    <td><?php the_author_meta('nickname', $current_user->ID); ?></td>
                </tr>
                <tr>
                    <td>
                        <?php _e('الأسم', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('first_name', $current_user->ID); ?></td>
                </tr>
                <tr>
                    <td>
                        <?php _e('البريد الألكترونى', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('user_email', $current_user->ID); ?></td>
                </tr>
                <tr>
                    <td>
                        <?php _e('الجوال', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('user_mobile', $current_user->ID); ?></td>
                </tr>

                <tr>
                    <td>
                          <?php _e("<!--:en--> Country of Residence <!--:--><!--:ar-->  بلد الإقامة<!--:-->"); ?>:
                    </td>
                    <td><?php the_author_meta('user_mycitynow', $current_user->ID); ?></td>
                </tr>

                <?php if (get_field('user_membership', 'user_' . $current_user->ID) == 'instructor'): ?>
                <tr>
                    <td>
                        <?php _e(' هل لديك تصنيف من الهيئة', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('user_member_type', $current_user->ID); ?></td>
                </tr>
                <tr>
                    <td>
                        <?php _e('رقم التصنيف ان وجد', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('user_classificationNum', $current_user->ID); ?></td>
                </tr>
                <tr>
                    <td>
                        <?php _e('الوظيفة', 'm7md') ?>:
                    </td>
                    <td><?php the_author_meta('user_job', $current_user->ID); ?></td>
                </tr>
                <?php endif; ?>

                </tbody>
            </table>
        </div>


    </div>
</section>


<?php get_footer(); ?>
